#include <omero/all.h>
#include <omero/client.h>
#include <omero/model/Image.h>
#include <omero/model/Pixels.h>

int main( int argc, char **argv )
{
	omero::client_ptr omero = new omero::client("omero.nbi.bbsrc.ac.uk");
	omero::api::ServiceFactoryPrx sf = omero->createSession("USERNAME", "PASSWORD");

	omero::api::PixelsService pixelsService = sf->getPixelsService();
	omero::api::Gateway gateway = sf->createGateway();
	omero::api::RawPixelsStore rawPixelsStore = sf->createRawPixelsStore();

	omero::model::Pixels pixelsObject = gateway->getPixels(1540);
	rawPixelsStore->setPixelsId(1540, false);

	long xdim = pixelsObject->getSizeX()->getValue();
	long ydim = pixelsObject->getSizeY()->getValue();
	long zdim = pixelsObject->getSizeZ()->getValue();
	long cdim = pixelsObject->getSizeC()->getValue();
	long tdim = pixelsObject->getSizeT()->getValue();

	double xphysize = pixelsObject->getPhysicalSizeX()->getValue();
	double yphysize = pixelsObject->getPhysicalSizeY()->getValue();
	double zphysize = pixelsObject->getPhysicalSizeZ()->getValue();

	for(int t=0; c<tdim; t++)
	{
		for(int c=0; c<xdim; c++)
		{
			for(int z=0; z<zdim; z++)
			{
				Ice::ByteSeq pixs = rawPixelsStore->getPlane(z,c,t);
				for(int x=0; x<xdim; x++)
				{
					for(int y=0; y<ydim; y++)
					{
						int index2d = (int) (y * xdim + x);
						cout<<"Pixels: "<<pixs[index2d]<<endl;
					}
				}
			}
		}
	}

		return 0;
}
